/*
 * Put all your regular jQuery in here.
*/
jQuery(document).ready(function($) {

// Config Sliding navigation and banner
// =================================================

var $root          = $('#inner-header'),
    $nav_header    = $('.banner'),
    $logoheader    = $('#logo'),
    header_height  = $('.banner').height(),
    hero_height    = $('.hero').height(),
    offset_val     = hero_height - header_height,
    eventType      = ((document.ontouchstart !== null) ? 'click' : 'touchstart');


// Methods
// =================================================

function navSlide() {
  var scroll_top = $(window).scrollTop();

    
  if (scroll_top >= offset_val) {
    $nav_header.addClass('is-sticky');
  } else {
    $nav_header.removeClass('is-sticky');
  }
    
}

function menuToggle() {
  if($nav_header.hasClass('is-open')) {
    $root.removeClass('pinned');
    $nav_header.removeClass('is-open');
  } else {
    $root.addClass('pinned');
    $nav_header.addClass('is-open')
  }
}

function openNav() {
  if ($nav_header.hasClass('is-open')) {
    $nav_header.removeClass('is-open');
    $root.removeClass('pinned');
  }
}

function anchorScroll(event) {
  var id     = $(this).attr('href'),
      offset = header_height,
      target = $(id).offset().top - offset;

  $('#inner-header').animate({
    scrollTop: target
  }, 300);

  event.preventDefault();
}


// Handlers
// =================================================

$('.scrollto').on(eventType, function() {
  anchorScroll.call(this, event);
});


$('.banner a').on(eventType, openNav);

$(window).scroll(navSlide);
 

    
}); /* end of as page load scripts */
