/*
 * Bones Scripts File
 * Author: Eddie Machado
 *
 * This file should contain any js scripts you want to add to the site.
 * Instead of calling it in the header or throwing it inside wp_head()
 * this file will be called automatically in the footer so as not to
 * slow the page load.
 *
 * There are a lot of example functions and tools in here. If you don't
 * need any of it, just remove it. They are meant to be helpers and are
 * not required. It's your world baby, you can do whatever you want.
*/


/*
 * Get Viewport Dimensions
 * returns object with viewport dimensions to match css in width and height properties
 * ( source: http://andylangton.co.uk/blog/development/get-viewport-size-width-and-height-javascript )
*/
function updateViewportDimensions() {
	var w=window,d=document,e=d.documentElement,g=d.getElementsByTagName('body')[0],x=w.innerWidth||e.clientWidth||g.clientWidth,y=w.innerHeight||e.clientHeight||g.clientHeight;
	return { width:x,height:y };
}
// setting the viewport width
var viewport = updateViewportDimensions();


/*
 * Throttle Resize-triggered Events
 * Wrap your actions in this function to throttle the frequency of firing them off, for better performance, esp. on mobile.
 * ( source: http://stackoverflow.com/questions/2854407/javascript-jquery-window-resize-how-to-fire-after-the-resize-is-completed )
*/
var waitForFinalEvent = (function () {
	var timers = {};
	return function (callback, ms, uniqueId) {
		if (!uniqueId) { uniqueId = "Don't call this twice without a uniqueId"; }
		if (timers[uniqueId]) { clearTimeout (timers[uniqueId]); }
		timers[uniqueId] = setTimeout(callback, ms);
	};
})();

// how long to wait before deciding the resize has stopped, in ms. Around 50-100 should work ok.
var timeToWaitForLast = 100;


/*
 * Here's an example so you can see how we're using the above function
 *
 * This is commented out so it won't work, but you can copy it and
 * remove the comments.
 *
 *
 *
 * If we want to only do it on a certain page, we can setup checks so we do it
 * as efficient as possible.
 *
 * if( typeof is_home === "undefined" ) var is_home = $('body').hasClass('home');
 *
 * This once checks to see if you're on the home page based on the body class
 * We can then use that check to perform actions on the home page only
 *
 * When the window is resized, we perform this function
 * $(window).resize(function () {
 *
 *    // if we're on the home page, we wait the set amount (in function above) then fire the function
 *    if( is_home ) { waitForFinalEvent( function() {
 *
 *	// update the viewport, in case the window size has changed
 *	viewport = updateViewportDimensions();
 *
 *      // if we're above or equal to 768 fire this off
 *      if( viewport.width >= 768 ) {
 *        console.log('On home page and window sized to 768 width or more.');
 *      } else {
 *        // otherwise, let's do this instead
 *        console.log('Not on home page, or window sized to less than 768.');
 *      }
 *
 *    }, timeToWaitForLast, "your-function-identifier-string"); }
 * });
 *
 * Pretty cool huh? You can create functions like this to conditionally load
 * content and other stuff dependent on the viewport.
 * Remember that mobile devices and javascript aren't the best of friends.
 * Keep it light and always make sure the larger viewports are doing the heavy lifting.
 *
*/

/*
 * We're going to swap out the gravatars.
 * In the functions.php file, you can see we're not loading the gravatar
 * images on mobile to save bandwidth. Once we hit an acceptable viewport
 * then we can swap out those images since they are located in a data attribute.
*/
function loadGravatars() {
  // set the viewport using the function above
  viewport = updateViewportDimensions();
  // if the viewport is tablet or larger, we load in the gravatars
  if (viewport.width >= 768) {
  jQuery('.comment img[data-gravatar]').each(function(){
    jQuery(this).attr('src',jQuery(this).attr('data-gravatar'));
  });
	}
} // end function


/*
 * Put all your regular jQuery in here.
*/
jQuery(document).ready(function($) {
    
    var map;
var colorado = new google.maps.LatLng(39.970762, -104.987406);

var MY_MAPTYPE_ID = 'custom_style';

function initialize() {

  var featureOpts = [
    {
      stylers: [
        { saturation: -100  }
      ]
    },
    {
      elementType: 'labels',
      stylers: [
        { visibility: 'on' }
      ]
    },
  ];

  var mapOptions = {
    zoom: 7,
    center: {lat: 39.378851, lng: -105.097269},
      draggable:true,
      scrollwheel: false,
    mapTypeControlOptions: {
      mapTypeIds: [google.maps.MapTypeId.ROADMAP, MY_MAPTYPE_ID]
    },
    mapTypeId: MY_MAPTYPE_ID
  };

  map = new google.maps.Map(document.getElementById('map-canvas'),
      mapOptions);

  var styledMapOptions = {
    name: 'Custom Style'
  };

var customMapType = new google.maps.StyledMapType(featureOpts, styledMapOptions);
var image = '/wp-content/themes/bones/library/images/map-marker-small.png';
var infowindow = new google.maps.InfoWindow;

map.mapTypes.set(MY_MAPTYPE_ID, customMapType);
    
/*------------Begin Salida Custom Map----------------*/
  var contentStringSalida = 
      '<div id="content">'+
      '<div id="siteNotice">'+
      '</div>'+
      '<h1 id="firstHeading" class="firstHeading">Mahnke Salida</h1>'+
      '<div id="bodyContent">'+
      '<p>Visit our location at</p>'+
      '<p><a target="_blank" href="https://www.google.com/maps/dir//716+Park+Ave,+Salida,+CO+81201/@38.5314279,-106.0202932,13z/data=!4m8!4m7!1m0!1m5!1m1!1s0x871517ee8fec9acb:0x8700cd78c463085b!2m2!1d-105.9852737!2d38.531366">716 Park Ave, Salida, CO 81201</a></p> '+
      '<p><a href="tel:719-539-7359">(719) 539-7359</a></p>'+
      '</div>'+
      '</div>';
	var image = '/wp-content/themes/bones/library/images/map-marker-small.png';
    var mysalidaLatLng = new google.maps.LatLng(38.5314279, -106.0202932);
    var salidaMarker = new google.maps.Marker({
      position: mysalidaLatLng,
      map: map,
      icon: image,
      title: 'Mahnke Salida',
  });
    google.maps.event.addListener(salidaMarker, 'click', function() {
        infowindow.setContent(contentStringSalida);
        infowindow.open(map,salidaMarker);
    });
/*--------------End Salida Custom Map-------------------*/ 
	
/*------------Begin Arvada Custom Map----------------*/
  var contentStringArvada = 
      '<div id="content">'+
      '<div id="siteNotice">'+
      '</div>'+
      '<h1 id="firstHeading" class="firstHeading">Mahnke Arvada</h1>'+
      '<div id="bodyContent">'+
      '<p>Visit our location at</p>'+
      '<p><a target="_blank" href="https://www.google.com/maps/dir//5855+W+56th+Ave,+Arvada,+CO+80002/@39.79911,-105.060357,17z/data=!4m13!1m4!3m3!1s0x876b87dcb4c3587b:0x3bff67218c40cdae!2s5855+W+56th+Ave,+Arvada,+CO+80002!3b1!4m7!1m0!1m5!1m1!1s0x876b87dcb4c3587b:0x3bff67218c40cdae!2m2!1d-105.060357!2d39.79911">5855 W. 56th Avenue Arvada, CO 80002</a></p> '+
      '<p><a href="tel:303-424-6091">(303) 424-6091</a></p>'+
      '</div>'+
      '</div>';

    var myarvadaLatLng = new google.maps.LatLng(39.799349, -105.060352);
    var arvadaMarker = new google.maps.Marker({
      position: myarvadaLatLng,
      map: map,
      icon: image,
      title: 'Mahnke Arvada',
  });
    google.maps.event.addListener(arvadaMarker, 'click', function() {
        infowindow.setContent(contentStringArvada);
        infowindow.open(map,arvadaMarker);
    });
/*--------------End Arvada Custom Map-------------------*/ 

/*------------Begin Brighton Custom Map----------------*/
    var contentStringBrighton = '<div id="content">'+
      '<div id="siteNotice">'+
      '</div>'+
      '<h1 id="firstHeading" class="firstHeading">Mahnke Brighton</h1>'+
      '<div id="bodyContent">'+
      '<p>Visit our location at</p>'+
      '<p><a target="_blank" href="https://www.google.com/maps/dir//109+W+Walnut+St,+Brighton,+CO+80601/@39.9893085,-104.8256548,17z/data=!4m13!1m4!3m3!1s0x876c6d4648f60f33:0xdadf07cce823aa45!2s109+W+Walnut+St,+Brighton,+CO+80601!3b1!4m7!1m0!1m5!1m1!1s0x876c6d4648f60f33:0xdadf07cce823aa45!2m2!1d-104.8256548!2d39.9893085">109 W. Walnut Street Brighton, CO 80601</a></p> '+
      '<p><a href="tel:303-654-1191">(303) 654-1191</a></p>'+
      '</div>'+
      '</div>';
    
    var mybrightonLatLng = new google.maps.LatLng(39.989563, -104.825682);
    var brightonMarker = new google.maps.Marker({
      position: mybrightonLatLng,
      map: map,
      icon: image,
     title: 'Mahnke Brighton'
});
    google.maps.event.addListener(brightonMarker, 'click', function() {
    infowindow.setContent(contentStringBrighton);
    infowindow.open(map,brightonMarker);
});
/*--------------End Brighton Custom Map-------------------*/ 

/*------------Begin Frederick Custom Map----------------*/
    var contentStringFrederick = '<div id="content">'+
      '<div id="siteNotice">'+
      '</div>'+
      '<h1 id="firstHeading" class="firstHeading">Mahnke Frederick</h1>'+
      '<div id="bodyContent">'+
      '<p>Visit our location at</p>'+
      '<p><a target="_blank" href="https://www.google.com/maps/dir//8478+Raspberry+Way,+Frederick,+CO+80504/@40.1238927,-104.9763803,17z/data=!4m13!1m4!3m3!1s0x876c088d072e8013:0x561b1ddb47d1681d!2s8478+Raspberry+Way,+Frederick,+CO+80504!3b1!4m7!1m0!1m5!1m1!1s0x876c088d072e8013:0x561b1ddb47d1681d!2m2!1d-104.9763803!2d40.1238927">8478 Raspberry Way Frederick, CO 80504</a></p> '+
      '<p><a href="tel:303-485-8840">(303) 485-8840</a></p>'+
      '</div>'+
      '</div>';

    var image = '/wp-content/themes/bones/library/images/map-marker-small.png';
    var myfrederickLatLng = new google.maps.LatLng(40.124147, -104.976343);
    var frederickMarker = new google.maps.Marker({
      position: myfrederickLatLng,
      map: map,
      icon: image
  });
    google.maps.event.addListener(frederickMarker, 'click', function() {
    infowindow.setContent(contentStringFrederick);
    infowindow.open(map,frederickMarker);
});
/*------------End Frederick Custom Map----------------*/

/*------------Begin Golden Custom Map----------------*/
        
    var contentStringGolden = '<div id="content">'+
      '<div id="siteNotice">'+
      '</div>'+
      '<h1 id="firstHeading" class="firstHeading">Mahnke Golden</h1>'+
      '<div id="bodyContent">'+
      '<p>Visit our location at</p>'+
      '<p><a target="_blank" href="https://www.google.com/maps/dir//446+Orchard+St,+Golden,+CO+80401/@39.7224244,-105.1792651,17z/data=!4m13!1m4!3m3!1s0x876b8485f0a012b5:0x3a29cd121fb0c068!2s446+Orchard+St,+Golden,+CO+80401!3b1!4m7!1m0!1m5!1m1!1s0x876b8485f0a012b5:0x3a29cd121fb0c068!2m2!1d-105.1792651!2d39.7224244">446 Orchard Street Golden, CO 80401</a></p> '+
      '<p><a href="tel:303-279-4223">(303) 279-4223</a></p>'+
      '</div>'+
      '</div>';

    var image = '/wp-content/themes/bones/library/images/map-marker-small.png';
    var mygoldenLatLng = new google.maps.LatLng(39.722647, -105.179249);
    var goldenMarker = new google.maps.Marker({
      position: mygoldenLatLng,
      map: map,
      icon: image
  });
    google.maps.event.addListener(goldenMarker, 'click', function() {
    infowindow.setContent(contentStringGolden);
    infowindow.open(map,goldenMarker);
});
/*------------End Golden Custom Map----------------*/
	
	
	  /*------------Begin Fort Lupton Custom Map----------------*/
    var contentStringFortLupton = '<div id="content">'+
      '<div id="siteNotice">'+
      '</div>'+
      '<h1 id="firstHeading" class="firstHeading">Mahnke Fort Lupton</h1>'+
      '<div id="bodyContent">'+
      '<p>Visit our location at</p>'+
      '<p><a target="_blank" href="https://www.google.com/maps/dir//540+Main+St,+Fort Lupton,+CO+80621/@40.0848372,,-104.8093098,17z/data=!4m13!1m4!3m3!1s0x876b8485f0a012b5:0x3a29cd121fb0c068!2s540+Min+St,+Fort%20Lupton,+CO+80621!3b1!4m7!1m0!1m5!1m1!1s0x876b8485f0a012b5:0x3a29cd121fb0c068!2m2!1d-104.8093098!2d40.08483724">540 Main Street, Fort Lupton, CO 80621</a></p> '+
      '<p><a href="tel:303-502-3392">(303) 502-3392</a></p>'+
      '</div>'+
      '</div>';

    var image = '/wp-content/themes/bones/library/images/map-marker-small.png';
    var myFTLLatLng = new google.maps.LatLng(40.0848372, -104.8093098);
    var FTLMarker = new google.maps.Marker({
      position: myFTLLatLng,
      map: map,
      icon: image
  });
    google.maps.event.addListener(FTLMarker, 'click', function() {
    infowindow.setContent(contentStringFortLupton);
    infowindow.open(map,FTLMarker); 
});
	
	/*------------End Fort Lupton Custom Map----------------*/
	
	/*------------Begin Gunnison Custom Map----------------*/
    var contentStringGunnison = '<div id="content">'+
      '<div id="siteNotice">'+
      '</div>'+
      '<h1 id="firstHeading" class="firstHeading">Mahnke Gunnison</h1>'+
      '<div id="bodyContent">'+
      '<p>Visit our location at</p>'+
      '<p><a target="_blank" href="https://www.google.com/maps/place/Mahnke+Auto+Body/@38.537675,-106.938471,15z/data=!4m5!3m4!1s0x0:0x99167c0655775931!8m2!3d38.537675!4d-106.938471">702 S. 9th Street, Gunnison, CO  81230</a></p> '+
      '<p><a href="tel:970-641-5510">(970) 641-5510</a></p>'+
      '</div>'+
      '</div>';

    var image = '/wp-content/themes/bones/library/images/map-marker-small.png';
    var myGunnisonLatLng = new google.maps.LatLng(38.537675, -106.938471);
    var GunnisonMarker = new google.maps.Marker({
      position: myGunnisonLatLng,
      map: map,
      icon: image
  });
    google.maps.event.addListener(GunnisonMarker, 'click', function() {
    infowindow.setContent(contentStringGunnison);
    infowindow.open(map,GunnisonMarker); 
});
/*------------End Gunnison Custom Map----------------*/
   
} 
google.maps.event.addDomListener(window, 'load', initialize);

// Config Sliding navigation and banner
// =================================================

var $root          = $('#inner-header'),
    $nav_header    = $('.banner'),
    $logoheader    = $('#logo'),
    header_height  = $('.banner').height(),
    hero_height    = $('.hero').height(),
    offset_val     = hero_height - header_height,
    eventType      = ((document.ontouchstart !== null) ? 'click' : 'touchstart');


// Methods
// =================================================

function navSlide() {
  var scroll_top = $(window).scrollTop();

  if (scroll_top >= offset_val) {
    $nav_header.addClass('is-sticky');
  } else {
    $nav_header.removeClass('is-sticky');
  }
    
}

function menuToggle() {
  if($nav_header.hasClass('is-open')) {
    $root.removeClass('pinned');
    $nav_header.removeClass('is-open');
  } else {
    $root.addClass('pinned');
    $nav_header.addClass('is-open')
  }
}

function openNav() {
  if ($nav_header.hasClass('is-open')) {
    $nav_header.removeClass('is-open');
    $root.removeClass('pinned');
  }
}

function anchorScroll(event) {
  var id     = $(this).attr('href'),
      offset = header_height,
      target = $(id).offset().top - offset;

  $('#inner-header').animate({
    scrollTop: target
  }, 300);

  event.preventDefault();
}


// Handlers
// =================================================

$('.scrollto').on(eventType, function() {
  anchorScroll.call(this, event);
});


$('.banner a').on(eventType, openNav);

$(window).scroll(navSlide);
    
    
    
 
 $(document).ready(function() {
 
    $('.faq_question, .faq_answer_container').click(function() {
 
        if ($(this).parent().is('.open')){
            $(this).closest('.faq').find('.faq_answer_container').animate({'height':'0'},500);
            $(this).closest('.faq').removeClass('open');
 
            }else{
                var newHeight =$(this).closest('.faq').find('.faq_answer').height() +'px';
                $(this).closest('.faq').find('.faq_answer_container').animate({'height':newHeight},500);
                $(this).closest('.faq').addClass('open');
            }
 
    });
 
});
    
}); /* end of as page load scripts */
